<?php /* Template Name: Sas Home */

get_header();
?>

<div class="banner bg-light-grey">

    <?php

    if(class_exists("\Elementor\Plugin")) {

        // Name of the template to search for
        $template_name = 'Banner';

        // Searches for the template by section name
        $templates = get_posts(array(
            'post_type' => 'elementor_library',
            's' => $template_name,
        ));

        // If the template is found, display it
        if (!empty($templates)) {
            // Gets the ID of the found template
            $template_id = $templates[0]->ID;

            // Displays the template using the found ID
            echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($template_id);
        }
    } else { ?>
        <div class="text-center text-danger p-5 m-5">
            Elementor Plugin not found. Please, install elementor plugin or load Search And Stay no elementor theme instead.
        </div>
    <?php } ?>
</div>

<div class="sas-row home-search bg-light-grey">
    <div class="container">
        <div class="search-form">
            
            <?php echo do_shortcode('[saswp-property-search-form-location]'); ?>
        
        </div>
    </div>
</div>

<div class="bg-light-grey">
  <div class="container">
    <br>
    <?php the_content(); ?>
  </div>
</div>

<div class="sas-row bg-light-grey">
  <div class="container">
    <?php
    if(class_exists("\Elementor\Plugin")) {
        // Name of the template to search for
        $template_name = 'Home Multi Properties';

        // Searches for the template by section name
        $templates = get_posts(array(
            'post_type' => 'elementor_library',
            's' => $template_name,
        ));

        // If the template is found, display it
        if (!empty($templates)) {
            // Gets the ID of the found template
            $template_id = $templates[0]->ID;

            // Displays the template using the found ID
            echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($template_id);
        }
    } else { ?>
        <div class="text-center text-danger p-5 m-5">
            Elementor Plugin not found. Please, install elementor plugin or load Search And Stay no elementor theme instead.
        </div>
    <?php } ?>
  </div>
</div>


<?php get_footer(); ?>