<?php
    $footer_logo = get_theme_mod('custom-footer-logo');
    $twitter_social = get_theme_mod('twitter-social');
    $facebook_social = get_theme_mod('facebook-social');
    $google_social = get_theme_mod('google-social');
    $instagram_social = get_theme_mod('instagram-social');

    $has_social_list = false;
    $social_footer_list = array($twitter_social, $facebook_social, $google_social, $instagram_social);

    foreach($social_footer_list as $social) {
        if($social !== "") {
            $has_social_list = true;
            break;
        }
    }

    $social_footer_complete_list = array(
        [
            "name" => "Twitter X",
            "class" => "twitter-x",
            "link" => $twitter_social,
            "icon" => get_template_directory_uri() . "/assets/images/x-twitter.svg"
        ],
        [
            "name" => "Facebook",
            "class" => "facebook",
            "link" => $facebook_social,
            "icon" => get_template_directory_uri() . "/assets/images/facebook.svg"
        ],
        [
            "name" => "Google Plus",
            "class" => "google",
            "link" => $google_social,
            "icon" => get_template_directory_uri() . "/assets/images/google.svg"
        ],
        [
            "name" => "Instagram",
            "class" => "instagram",
            "link" => $instagram_social,
            "icon" => get_template_directory_uri() . "/assets/images/instagram.svg"
        ]
    );
?>
        </main>
    </div>

    <footer>

        <div class="sas-row copyright">
            <div class="container">
                <div class="left-col">
                    <?php if($footer_logo && $footer_logo !== "") { ?>
                        <img src="<?php echo $footer_logo; ?>" alt="<?php echo get_bloginfo('name'); ?>" />
                    <?php } ?>
                </div>

                <div class="right-col">
                    <?php if($has_social_list) { ?>
                    <ul class="social">
                        <?php foreach($social_footer_complete_list as $social) { 
                            if($social['link'] && $social["link"] !== "") { ?>
                            <li>
                                <a href="<?php echo $social["link"] ?>" target="_blank">
                                    <img src="<?php echo $social["icon"] ?>" alt="<?php echo $social["name"] ?>" class="<?php echo $social["class"] ?>">
                                </a>
                            </li>
                            <?php } 
                        } ?>
                    </ul>
                    <?php } ?>
                </div>
                <div class="powered">
                    <span>Powered by</span>
                    <a href="https://breakz.com/" target="_blank">
                        <img src="<?php echo get_template_directory_uri() . "/assets/images/breakz-powered.png" ?>" alt="Breakz" style="max-width: 55px !important;" />
                    </a>
                </div>
            </div>
        </div>

    </footer>

    <?php wp_footer(); ?>
    
</body>

</html>