<?php

//* Add custom sections to the Wordpress Customizer
class Sas_Customizer{
    public function __construct() {
        add_action('customize_register', array($this, 'register_customize_sections'));
    }

    public function register_customize_sections ($wp_customize){
        // Call section
        $this->home_slider($wp_customize);
        $this->home_about_us($wp_customize);
        $this->home_contact_us($wp_customize);
        $this->social_links($wp_customize);
        $this->footer_logo($wp_customize);
    }

    // Homepage Slider
    private function home_slider($wp_customize){

        //Section Panel
        $wp_customize->add_section('home-slider', array(
            'title' => 'Homepage Slider',
            'priority' => 2,
            'description' => __('In this section you will be able to manage the homepage slideshow.', 'sastheme'),
        ));

        //Slider Display Control
        $wp_customize->add_setting('home-slider-display', array(
            'default' => 'No',
            'sanitize_callback' => array($this, 'sanitize_custom_option'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'home-slider-display-control', array(
            'label' => 'Display homepage slider?',
            'section' => 'home-slider',
            'settings' => 'home-slider-display',
            'type' => 'select',
            'choices' => array('No' => 'No', 'Yes' => 'Yes')
        )));

        //Slider Images Control
       $slider_labels = array(
        'Image 1' => 'slider_1',
        'Image 2' => 'slider_2',
        'Image 3' => 'slider_3'
       );

       foreach ($slider_labels as $slider_label => $slider_name){
        $setting_id = sprintf('sas_%s', $slider_name);

        $wp_customize->add_setting($setting_id);

        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, $setting_id, array(
            'label' => esc_html__($slider_label, 'sastheme'),
            'section' => 'home-slider',
            'settings' => $setting_id   
        )));
       }

    }

    // Homepage About Us
    private function home_about_us($wp_customize){

        //Section Panel
        $wp_customize->add_section('about-us', array(
            'title' => 'About Us',
            'priority' => 3,
            'description' => __('In this section you will be able to manage the homepage "about us" section content.', 'sastheme'),
        ));

        //About Title
        $wp_customize->add_setting('home-about-title', array(
            'default' => 'A best place to enjoy your life',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'about-us-title', array(
            'label' => 'Title',
            'section' => 'about-us',
            'settings' => 'home-about-title',
            'type' => 'text'
        )));

        //About Subtitle
        $wp_customize->add_setting('home-about-subtitle', array(
            'default' => 'Little About Us ',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'about-us-subtitle', array(
            'label' => 'Subtitle',
            'section' => 'about-us',
            'settings' => 'home-about-subtitle',
            'type' => 'text'
        )));

        //About Text
        $wp_customize->add_setting('home-about-text', array(
            'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque congue velit eu ex pharetra fringilla sodales quis neque. Duis facilisis, purus eu faucibus aliquet, ipsum magna aliquam justo, in sodales magna nunc ac neque. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'about-us-text', array(
            'label' => 'Text',
            'section' => 'about-us',
            'settings' => 'home-about-text',
            'type' => 'textarea'
        )));

        //About Image
        $wp_customize->add_setting('home-about-image', array(
            'default' => '',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => array($this, 'sanitize_custom_url'),
        ));

        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'about-us-image', array(
            'label' => 'Image 400x447',
            'section' => 'about-us',
            'settings' => 'home-about-image'   
        )));
        
    }

    // Homepage Contact Us
    private function home_contact_us($wp_customize){

        //Section Panel
        $wp_customize->add_section('contact-us', array(
            'title' => 'Contact Us',
            'priority' => 4,
            'description' => __('In this section you will be able to manage the homepage "contact us" section content.', 'sastheme'),
        ));

        //Contact Title
        $wp_customize->add_setting('home-contact-title', array(
            'default' => 'Contact us',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'contact-us-title', array(
            'label' => 'Title',
            'section' => 'contact-us',
            'settings' => 'home-contact-title',
            'type' => 'text'
        )));

        //Contact Subtitle
        $wp_customize->add_setting('home-contact-subtitle', array(
            'default' => 'Information',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'contact-us-subtitle', array(
            'label' => 'Subtitle',
            'section' => 'contact-us',
            'settings' => 'home-contact-subtitle',
            'type' => 'text'
        )));

        //Contact Address
        $wp_customize->add_setting('home-contact-address', array(
            'default' => '269 King Str, 05th Floor, Utral Hosue Building, Melbourne, VIC 3000, Australia.',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'contact-us-address', array(
            'label' => 'Address',
            'section' => 'contact-us',
            'settings' => 'home-contact-address',
            'type' => 'text'
        )));

        //Contact Email
        $wp_customize->add_setting('home-contact-email', array(
            'default' => 'info@example.com',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'contact-us-email', array(
            'label' => 'Email',
            'section' => 'contact-us',
            'settings' => 'home-contact-email',
            'type' => 'text'
        )));

        //Contact Phone
        $wp_customize->add_setting('home-contact-phone', array(
            'default' => '+99 (0) 344 956 4050',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'contact-us-phone', array(
            'label' => 'Phone',
            'section' => 'contact-us',
            'settings' => 'home-contact-phone',
            'type' => 'text'
        )));

        //Contact Image
        $wp_customize->add_setting('home-contact-image', array(
            'default' => '',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => array($this, 'sanitize_custom_url'),
        ));

        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'contact-us-image', array(
            'label' => 'Image 1075x870',
            'section' => 'contact-us',
            'settings' => 'home-contact-image'   
        )));
        
    }

    //Social Links
    private function social_links($wp_customize){

        //Section Panel
        $wp_customize->add_section('social-links', array(
            'title' => 'Social Links',
            'priority' => 5,
            'description' => __('In this section you will be able to manage your social links.', 'sastheme'),
        ));

        //Twitter
        $wp_customize->add_setting('twitter-social', array(
            'default' => '',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'twitter-social-link', array(
            'label' => 'X (Twitter)',
            'section' => 'social-links',
            'settings' => 'twitter-social',
            'type' => 'text'
        )));

        //Facebook
        $wp_customize->add_setting('facebook-social', array(
            'default' => '',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'facebook-social-link', array(
            'label' => 'Facebook',
            'section' => 'social-links',
            'settings' => 'facebook-social',
            'type' => 'text'
        )));

        //Google+
        $wp_customize->add_setting('google-social', array(
            'default' => '',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'google-social-link', array(
            'label' => 'Google+',
            'section' => 'social-links',
            'settings' => 'google-social',
            'type' => 'text'
        )));


        //Instagram
        $wp_customize->add_setting('instagram-social', array(
            'default' => '',
            'sanitize_callback' => array($this, 'sanitize_custom_text'),
        ));

        $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'instagram-social-link', array(
            'label' => 'Instagram',
            'section' => 'social-links',
            'settings' => 'instagram-social',
            'type' => 'text'
        )));
    }

    //Footer Logo
    private function footer_logo($wp_customize){
        
        $wp_customize->add_setting('custom-footer-logo', array(
            'default' => '',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => array($this, 'sanitize_custom_url'),
        ));

        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'footer-logo', array(
            'label' => 'Footer Logo',
            'section' => 'title_tagline',
            'settings' => 'custom-footer-logo'   
        )));
    }

    //Sanitize Functions
    public function sanitize_custom_option($input) {
        return ($input === 'No') ? 'No' : 'Yes';
    }

    public function sanitize_custom_url($input) {
        return filter_var($input, FILTER_SANITIZE_URL);
    }

    public function sanitize_custom_text($input) {
        return filter_var($input, FILTER_SANITIZE_STRING);
    }
}