<?php /* Template Name: Sas Property List */

get_header();
?>

<?php if( get_theme_mod('home-slider-display') === 'Yes'){ ?>

<div class="sas-slider">
    <?php
        $slider_labels = array(
            'Image 1' => 'slider_1',
            'Image 2' => 'slider_2',
            'Image 3' => 'slider_3'
        );

        foreach ($slider_labels as $slider_label => $slider_name){
            $setting_id = sprintf('sas_%s', $slider_name);
            $slide_url = get_theme_mod ($setting_id);
            if (! empty($slide_url) ){
                ?>
                    <div><img src="<?php echo $slide_url; ?>" alt="<?php echo esc_html($slider_label); ?>"></div>
                <?php
            }
        }
    ?>
</div>

<?php } else { ?>

<div class="sas-slider-off">
    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/homepage-slider.png">
</div>

<?php } ?>

<div class="sas-row home-search">
    <div class="container">
        <div class="search-form">
            <?php echo do_shortcode( '[saswp-theme-home-search]' ); ?>
        </div>
    </div>
</div>

<div class="sas-row property-list" id="property-list">
    <div class="img-col">
        <img src="<?php echo get_template_directory_uri()."/assets/images/845x603.png";?>" class="contact-img"/>
    </div>
    <div class="details">
        <h3 class="sas-title">Grand deluxe room</h3>

        <div class="property-details">
            <div class="price-box">Start from <span class="price">$59.00</span> / Night</div>
            <div class="desc">Ullamcorper eros ac ultrices imperdiet. Vivamus eros nibh, dictum sed venenatis vitae, ornare eget magna. Etiam mattis, felis eu interdum posuere, justo neque dictum sapien, eu luctus neque nulla non ante. Quisque pharetra facilisis...</div>
            <div class="info">
                <div class="status">Status:<span> 03 Rooms Left!</span></div>
                <div class="info-item">Deposit:<span> Required 30%</span></div>
                <div class="info-item">Beds:<span> 02</span></div>
                <div class="info-item">Guests:<span> 04-06</span></div>
            </div>
            <a href="#" class="view-more">View Details &#10148;</a>
        </div>
    </div>
</div>

<div class="sas-row property-list" id="property-list">
    <div class="details">
        <h3 class="sas-title">Grand deluxe room</h3>

        <div class="property-details">
            <div class="price-box">Start from <span class="price">$59.00</span> / Night</div>
            <div class="desc">Ullamcorper eros ac ultrices imperdiet. Vivamus eros nibh, dictum sed venenatis vitae, ornare eget magna. Etiam mattis, felis eu interdum posuere, justo neque dictum sapien, eu luctus neque nulla non ante. Quisque pharetra facilisis...</div>
            <div class="info">
                <div class="status">Status:<span> 03 Rooms Left!</span></div>
                <div class="info-item">Deposit:<span> Required 30%</span></div>
                <div class="info-item">Beds:<span> 02</span></div>
                <div class="info-item">Guests:<span> 04-06</span></div>
            </div>
            <a href="#" class="view-more">View Details &#10148;</a>
        </div>
    </div>

    <div class="img-col">
        <img src="<?php echo get_template_directory_uri()."/assets/images/845x603.png";?>" class="contact-img"/>
    </div>
</div>

<div class="sas-row property-list" id="property-list">
    <div class="img-col">
        <img src="<?php echo get_template_directory_uri()."/assets/images/845x603.png";?>" class="contact-img"/>
    </div>
    <div class="details">
        <h3 class="sas-title">Grand deluxe room</h3>

        <div class="property-details">
            <div class="price-box">Start from <span class="price">$59.00</span> / Night</div>
            <div class="desc">Ullamcorper eros ac ultrices imperdiet. Vivamus eros nibh, dictum sed venenatis vitae, ornare eget magna. Etiam mattis, felis eu interdum posuere, justo neque dictum sapien, eu luctus neque nulla non ante. Quisque pharetra facilisis...</div>
            <div class="info">
                <div class="status">Status:<span> 03 Rooms Left!</span></div>
                <div class="info-item">Deposit:<span> Required 30%</span></div>
                <div class="info-item">Beds:<span> 02</span></div>
                <div class="info-item">Guests:<span> 04-06</span></div>
            </div>
            <a href="#" class="view-more">View Details &#10148;</a>
        </div>
    </div>
</div>

<a href="#" class="load-more">See More Properties</a>

<?php get_footer(); ?>