<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 */
if ( ! function_exists( 'sas_setup' ) ) {
    function sas_setup() {
		add_theme_support('elementor');

        register_nav_menus([
			'main' => esc_html__('Main', 'sastheme')
		]);

        /*
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */

		add_theme_support(
			'custom-logo',
			array(
				'flex-width'           => true,
				'flex-height'          => true,
				'unlink-homepage-logo' => true,
			)
		);

		add_theme_support('post-thumbnails');
    }
}

add_action( 'after_setup_theme', 'sas_setup' );

function sas_scripts() {
	wp_enqueue_style('sas-style', get_template_directory_uri() . '/style.css', array(), wp_get_theme()->get( 'Version' ) );
    wp_enqueue_style('bootstrap-5', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css');
    wp_enqueue_style('custom', get_stylesheet_directory_uri() . '/assets/css/custom.css');
    wp_enqueue_script('jquery-min-js', get_template_directory_uri().'/assets/js/jquery-3.7.0.min.js', array(), '3.7.0');        
    wp_enqueue_script('scripts-js', get_template_directory_uri().'/assets/js/scripts.js');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js');
}

add_action( 'wp_enqueue_scripts', 'sas_scripts' );

require_once dirname( __FILE__ ) . '/inc/class-tgm-plugin-activation.php';

require dirname( __FILE__ ) . '/inc/sas-required-plugins.php';
new Sas_Required_Plugins();

require dirname( __FILE__ ) . '/inc/sas-required-pages.php';
new Sas_Required_Pages();

require dirname( __FILE__ ) . '/inc/sas-theme-navigation.php';
new Sas_Theme_Navigation();



function check_sas_plugin_installed()
{
	if (class_exists('Saswp\Api')) return;
	
	exit(<<<HTML
		<div class="container py-5 text-center">
			<p>This theme requires Search and Stay plugin to work properly.</p>
			<p><a href="#">Click here to download and install Search and Stay plugin</a>.</p>
			<p>If you need help, you can follow the <a href="#">installation instructions</a>.</p>
		</div>
	HTML);
}