<?php get_header(); ?>

<div class="sas-row blog-archive">
    <div class="container-xl">

        <?php if ($page_id = get_option('page_for_posts')) { ?>
            <h1><?php echo get_the_title($page_id); ?></h1>

            <div>
                <?php
                // the_content() doesn't accept a post ID parameter
                if ($post = get_post($page_id)) {
                    setup_postdata($post); //  "posts" page is now current post for most template tags        
                    the_content();
                    wp_reset_postdata(); // So everything below functions as normal
                } ?>
            </div>
        <?php } ?>

        <div class="posts-container">
            <?php
            if (have_posts()) {
                while (have_posts()) {
                    the_post();
            ?>
                    <div class="item">
                        <?php if (!has_post_thumbnail()) { ?>
                            <a href="<?php the_permalink(); ?>">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/1920x795.png" />
                            </a>
                        <?php } else { ?>
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail(); ?>
                            </a>
                        <?php } ?>

                        <div class="arch-content">
                            <!--
                            <span class="post-date">
                                <?php //echo get_the_date(); ?>
                            </span>
                            -->

                            <h3 class="sas-title">
                                <?php the_title(); ?>
                            </h3>

                            <a class="view-btn" href="<?php the_permalink(); ?>">Continue &#10141;</a>
                        </div>
                    </div>

            <?php
                }
            }
            ?>
        </div>
        <div class="sas-pagination">
            <?php echo get_the_posts_pagination() ?>
        </div>
    </div>



</div>

<?php get_footer(); ?>