<?php

//* Theme Required Pages
class Sas_Required_Pages{
    public function __construct() {
        add_action( 'after_switch_theme', array($this, 'create_theme_homepage' ));
    }

    public function create_theme_homepage() {
        $page_slug = 'home';

        $new_page = array(
            'post_type'     => 'page',
            'post_title'    => 'Home',
            'post_content'  => '',
            'post_status'   => 'publish',
            'post_author'   => 1,
            'post_name'     => $page_slug,
            'page_template'  => 'templates/home.php'
        );

        if (!get_page_by_path( $page_slug, OBJECT, 'page')) {
            $new_page_id = wp_insert_post($new_page);

            update_option( 'page_on_front', $new_page_id );
            update_option( 'show_on_front', 'page' );
        }

        $blog = array(
            'post_type'     => 'page',
            'post_title'    => 'Blog',
            'post_content'  => '',
            'post_status'   => 'publish',
            'post_author'   => 1,
            'post_name'     => 'blog',
            'page_template' => 'templates/blog.php',
        );

        if (!get_page_by_path('blog', OBJECT, 'page')) {
            $blog_id = wp_insert_post($blog);
            update_option('page_for_posts', $blog_id);
        }
    }
}