<?php

//* Add Theme Navigation
class Sas_Theme_Navigation
{
    public function __construct()
    {

        add_action('after_switch_theme', array($this, 'create_theme_navigation'));

        //Menu Custom Fields
        add_action('wp_nav_menu_item_custom_fields', array($this, 'menu_item_data_form_id'), 10, 2);
        add_action('wp_nav_menu_item_custom_fields',  array($this, 'menu_item_onclick'), 10, 2);
        add_action('wp_update_nav_menu_item',  array($this, 'save_menu_item_data_form_id'), 10, 2);
        add_action('wp_update_nav_menu_item',  array($this, 'save_menu_item_onclick'), 10, 2);
        add_filter('walker_nav_menu_start_el',  array($this, 'show_menu_attr'), 10, 2);
    }

    public function create_theme_navigation()
    {

        if (wp_get_nav_menu_object('Main')) {
            wp_delete_nav_menu('Main');
        }

        $menu_id = wp_create_nav_menu('Main');

        $locations = get_theme_mod('nav_menu_locations');

        $locations['main'] = $menu_id;

        set_theme_mod('nav_menu_locations', $locations);

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('Home'),
            'menu-item-classes' => 'home',
            'menu-item-url' => home_url('/'),
            'menu-item-status' => 'publish'
        ));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('Blog'),
            'menu-item-classes' => 'blog',
            'menu-item-url' => site_url('/blog'),
            'menu-item-status' => 'publish'
        ));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('Login'),
            'menu-item-classes' => 'guest btn',
            'menu-item-url' => home_url('/user'),
            'menu-item-status' => 'publish'
        ));

    }

    //Add ID Custom field to Menu
    public function menu_item_data_form_id( $item_id, $item ) {
        $menu_item_data_form_id = get_post_meta( $item_id, '_menu_item_data_form_id', true );
        ?>
        <p class="fiel-data-form-id description description-wide">
            <label class="description"><?php _e( "Data Form ID", 'menu-item-data-form-id' ); ?></label><br />
            <input type="hidden" class="nav-menu-id" value="<?php echo $item_id ;?>" />
            <input class="widefat code edit-menu-item-data-form-id" type="text" name="menu_item_data_form_id[<?php echo $item_id ;?>]" id="menu-item-data-form-id-<?php echo $item_id ;?>" value="<?php echo esc_attr( $menu_item_data_form_id ); ?>" />
        </p>
        <?php
    }

    //Add Onclick Custom field to Menu
    public function menu_item_onclick( $item_id, $item ) {
        $menu_item_onclick = get_post_meta( $item_id, '_menu_item_onclick', true );
        ?>
        <p class="fiel-onclick description description-wide">
            <label class="description"><?php _e( "On Click", 'menu-item-onclick' ); ?></label>
            <input type="hidden" class="nav-menu-id" value="<?php echo $item_id ;?>" />
            <input class="widefat code edit-menu-item-onclick" type="text" name="menu_item_onclick[<?php echo $item_id ;?>]" id="menu-item-onclick-<?php echo $item_id ;?>" value="<?php echo esc_attr( $menu_item_onclick ); ?>" />
        </p>
        <?php
    }

    //Save ID Custom Field to Menu
    public function save_menu_item_data_form_id( $menu_id, $menu_item_db_id ) {
        if(isset($_POST['menu_item_data_form_id'][$menu_item_db_id]  ) ) {
            $sanitized_data = sanitize_text_field( $_POST['menu_item_data_form_id'][$menu_item_db_id] );
            update_post_meta( $menu_item_db_id, '_menu_item_data_form_id', $sanitized_data );
        } else {
            delete_post_meta( $menu_item_db_id, '_menu_item_data_form_id' );
        }
    }

    //Save Onclick Custom Field to Menu
    public function save_menu_item_onclick( $menu_id, $menu_item_db_id ) {
        if(isset($_POST['menu_item_onclick'][$menu_item_db_id]  ) ) {
            $sanitized_data = sanitize_text_field( $_POST['menu_item_onclick'][$menu_item_db_id] );
            update_post_meta( $menu_item_db_id, '_menu_item_onclick', $sanitized_data );
        } else {
            delete_post_meta( $menu_item_db_id, '_menu_item_onclick' );
        }
    }

    //Modify link output
    public function show_menu_attr($link, $item) {

        $menu_item_data_form_id = get_post_meta( $item->ID, '_menu_item_data_form_id', true );
        $menu_item_onclick = get_post_meta( $item->ID, '_menu_item_onclick', true );

        $parts = explode('>', $link);
        $out = array ();

        foreach($parts as $i => $part)
        {
            $mounted_part = $part;

            if(0 === strpos($part, '<a ')) {
                if($menu_item_data_form_id) {
                    $mounted_part .= ' data-form-id="' . $menu_item_data_form_id . '"'; 
                }
                if($menu_item_onclick) {
                    $mounted_part .= ' onclick=\'' . $menu_item_onclick . '\'';
                }
            }
            $out[$i] = $mounted_part;
        }

        return join( '>', $out );
    }

}