<?php

// position 0, 1 or 2

$options = getopt('p:');

_change_styles_version($options['p'] ?? 2);


function _change_styles_version(int $position = 2)
{
    foreach (['style.scss', 'style.css'] as $file) {

        $filename = __DIR__ . '/' . $file;

        $content = file_get_contents($filename);

        $content = preg_replace_callback('/(?!Version\:\s+)(\d+)\.(\d+)\.(\d+)/', function ($n) use ($position) {

            $numbers = array_slice($n, 1, $position + 1);

            $numbers[$position] += 1;

            return implode('.', $numbers + [0 => 0, 1 => 0, 2 => 0]);

        }, $content);

        file_put_contents($filename, $content);
    }
}
