<?php /* Template Name: Sas Home */
get_header(); ?>
<div class="banner">
    <?php
    // Name of the template to search for
    $template_name = 'Banner';

    // Searches for the template by section name
    $templates = get_posts(array(
        'post_type' => 'elementor_library',
        's' => $template_name,
    ));

    // If the template is found, display it
    if (!empty($templates)) {
        // Gets the ID of the found template
        $template_id = $templates[0]->ID;

        // Displays the template using the found ID
        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($template_id);
    }
    ?>
</div>

<div class="sas-row home-search">
    <div class="container">
        <div class="search-form">
        <?php echo do_shortcode('[search_single]'); ?>
        </div>
    </div>
</div>

<div class="sas-row bg-light-grey">
  <div class="container">
    <?php the_content(); ?>
  </div>
</div>

<div class="sas-row bg-light-grey">
  <div class="container">
    <?php
    // Name of the template to search for
    $template_name = 'Home';

    // Searches for the template by section name
    $templates = get_posts(array(
        'post_type' => 'elementor_library',
        's' => $template_name,
    ));

    // If the template is found, display it
    if (!empty($templates)) {
        // Gets the ID of the found template
        $template_id = $templates[0]->ID;

        // Displays the template using the found ID
        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($template_id);
    }
    ?>
  </div>
</div>
<?php get_footer(); ?>